package coreservlets.filters;

import java.io.*;
import java.text.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Filtr zapisuje informacje o wywoywaniu strony
 *  w niecodziennych godzinach.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */
public class LateAccessFilter implements Filter {
  private FilterConfig config;
  private ServletContext context;
  private int startTime, endTime;
  private DateFormat formatter;
  
  public void doFilter(ServletRequest request,
                       ServletResponse response,
                       FilterChain chain)
      throws ServletException, IOException {
    HttpServletRequest req = (HttpServletRequest)request;
    GregorianCalendar calendar = new GregorianCalendar();
    int currentTime = calendar.get(Calendar.HOUR_OF_DAY);
    if (isUnusualTime(currentTime, startTime, endTime)) {
      context.log("OSTRZEENIE: " +
                  req.getRemoteHost() +
                  " wywoana " +
                  req.getRequestURL() +
                  " w dniu " + 
                  formatter.format(calendar.getTime()));
    }
    chain.doFilter(request,response);
  }

  public void init(FilterConfig config)
      throws ServletException {
    this.config = config;
    context = config.getServletContext();
    formatter =
      DateFormat.getDateTimeInstance(DateFormat.MEDIUM,
                                     DateFormat.MEDIUM);
    try {
      startTime =
        Integer.parseInt(config.getInitParameter("startTime"));
      endTime =
        Integer.parseInt(config.getInitParameter("endTime"));
    } catch(NumberFormatException nfe) { // Zy format albo null
      // Domylnie jako niecodzienne traktowane s godziny
      // midzy 22 i 6 rano.
      startTime = 22;
      endTime = 6;
    }
  }
  
  public void destroy() {}

  // Czy aktualna godzina naley do zakresu godzin
  // wyznaczajcych niecodzienn por?
  private boolean isUnusualTime(int currentTime,
                                int startTime,
                                int endTime) {
    // Jeli godzina pocztkowa jest mniejsza ni godzina kocowa
    // (czyli s to godziny tego samego dnia), wwczas
    // godzina bieca jest uznawana za niecodzienn,
    // jeli znajduje si midzy godzin pocztkow i kocow.
    if (startTime < endTime) {
      return((currentTime >= startTime) &&
             (currentTime < endTime));
    }
    // Jeli godzina pocztkowa jest wiksza lub rwna
    // godzinie kocowej (czyli godzina pocztkowa naley do jednego dnia,
    // a godzina kocowa dotyczy ju nastpnego dnia),
    // wwczas godzina bieca jest uznawana za niecodzienn,
    // jeli NIE naley do przedziau midzy godzin kocow i pocztkow.
    else {
      return(!isUnusualTime(currentTime, endTime, startTime));
    }
  } 
}
